/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.plane;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.platforms.core.registries.AbstractCustomRegistryEntry;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class PlaneChiselMode
extends AbstractCustomRegistryEntry
implements IChiselMode {
    private final int depth;
    private final class_5250 displayName;
    private final class_5250 multiLineDisplayName;
    private final class_2960 iconName;

    PlaneChiselMode(int depth, class_5250 displayName, class_5250 multiLineDisplayName, class_2960 iconName) {
        this.depth = depth;
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
    }

    @Override
    public ClickProcessingState onLeftClickBy(class_1657 playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> class_243.method_24954((class_2382)face.method_10153().method_10163()), class_2350::method_10153);
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                context.setComplete();
                HashMap resultingBitCount = Maps.newHashMap();
                Predicate<IStateEntryInfo> filter = context.getStateFilter().map(builder -> (Predicate)builder.apply(mutator)).orElse(state -> true);
                int totalModifiedStates = mutator.inWorldMutableStream().filter(filter).mapToInt(state -> {
                    BlockInformation currentState = state.getBlockInformation();
                    return context.tryDamageItemAndDoOrSetBrokenError(() -> {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    });
                }).sum();
                if (totalModifiedStates == 0) {
                    context.setError(LocalStrings.ChiselAttemptFailedNoValidStateFound.getText());
                }
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedLeftClicking(class_1657 playerEntity, IChiselingContext context) {
    }

    @Override
    public ClickProcessingState onRightClickBy(class_1657 playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> class_243.method_24954((class_2382)face.method_10163()), Function.identity());
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            class_2338 heightPos;
            BlockInformation heldBlockState = ItemStackUtils.getHeldBitBlockInformationFromPlayer(playerEntity);
            if (heldBlockState.isAir()) {
                return ClickProcessingState.DEFAULT;
            }
            int missingBitCount = (int)mutator.stream().filter(state -> state.getBlockInformation().isAir()).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.method_7337()) {
                if (!playerEntity.method_7337()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getBlockInformation().isAir()).forEach(state -> state.overrideState(heldBlockState));
                }
            } else {
                context.setError(LocalStrings.ChiselAttemptFailedNotEnoughBits.getText(heldBlockState.getBlockState().method_26204().method_9518()));
            }
            if (missingBitCount == 0 && (heightPos = new class_2338(mutator.getInWorldEndPoint())).method_10264() >= context.getWorld().method_31600()) {
                class_5250 component = new class_2588("build.tooHigh", new Object[]{context.getWorld().method_31600() - 1}).method_27692(class_124.field_1061);
                playerEntity.method_9203((class_2561)component, class_156.field_25140);
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedRightClicking(class_1657 playerEntity, IChiselingContext context) {
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(mutator -> mutator);
    }

    private Optional<ClickProcessingState> processRayTraceIntoContext(class_1657 playerEntity, IChiselingContext context, Function<class_2350, class_243> placementFacingAdapter, Function<class_2350, class_2350> iterationAdaptor) {
        class_239 rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.method_17783() != class_239.class_240.field_1332 || !(rayTraceResult instanceof class_3965)) {
            context.setError(LocalStrings.ChiselAttemptFailedNoBlock.getText());
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        class_3965 blockRayTraceResult = (class_3965)rayTraceResult;
        class_243 hitVector = blockRayTraceResult.method_17784().method_1019(placementFacingAdapter.apply(blockRayTraceResult.method_17780()).method_18805((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        class_243 hitBlockPosVector = class_243.method_24954((class_2382)new class_2338(hitVector));
        class_243 inBlockHitVector = hitVector.method_1020(hitBlockPosVector);
        class_243 inBlockBitVector = inBlockHitVector.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide());
        class_2350 iterationDirection = iterationAdaptor.apply(blockRayTraceResult.method_17780());
        switch (iterationDirection) {
            case field_11033: {
                this.includeDownAxis(context, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case field_11036: {
                this.includeUpAxis(context, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case field_11043: {
                this.includeNorthAxis(context, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case field_11035: {
                this.includeSouthAxis(context, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case field_11039: {
                this.includeWestAxis(context, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case field_11034: {
                this.includeEastAxis(context, hitBlockPosVector, inBlockBitVector);
            }
        }
        return Optional.empty();
    }

    private void includeDownAxis(IChiselingContext context, class_243 hitBlockPosVector, class_243 inBlockBitVector) {
        class_2338 position = new class_2338(hitBlockPosVector);
        context.include(position, this.clampVectorToBlock(new class_243(0.0, inBlockBitVector.method_10214() - (double)this.depth, 0.0).method_1019(class_243.method_24954((class_2382)class_2350.field_11036.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new class_243(15.5, inBlockBitVector.method_10214() - (double)this.depth, 15.5).method_1019(class_243.method_24954((class_2382)class_2350.field_11036.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new class_243(0.0, inBlockBitVector.method_10214() - 0.5, 0.0).method_1019(class_243.method_24954((class_2382)class_2350.field_11036.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new class_243(15.5, inBlockBitVector.method_10214() - 0.5, 15.5).method_1019(class_243.method_24954((class_2382)class_2350.field_11036.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
    }

    private void includeUpAxis(IChiselingContext context, class_243 hitBlockPosVector, class_243 inBlockBitVector) {
        class_2338 position = new class_2338(hitBlockPosVector);
        context.include(position, this.clampVectorToBlock(new class_243(0.0, inBlockBitVector.method_10214() + (double)this.depth, 0.0).method_1019(class_243.method_24954((class_2382)class_2350.field_11033.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new class_243(15.5, inBlockBitVector.method_10214() + (double)this.depth, 15.5).method_1019(class_243.method_24954((class_2382)class_2350.field_11033.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new class_243(0.0, inBlockBitVector.method_10214() + 0.5, 0.0).method_1019(class_243.method_24954((class_2382)class_2350.field_11033.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new class_243(15.5, inBlockBitVector.method_10214() + 0.5, 15.5).method_1019(class_243.method_24954((class_2382)class_2350.field_11033.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
    }

    private void includeNorthAxis(IChiselingContext context, class_243 hitBlockPosVector, class_243 inBlockBitVector) {
        class_2338 position = new class_2338(hitBlockPosVector);
        context.include(position, this.clampVectorToBlock(new class_243(0.0, 0.0, inBlockBitVector.method_10215() - (double)this.depth).method_1019(class_243.method_24954((class_2382)class_2350.field_11035.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new class_243(15.5, 15.5, inBlockBitVector.method_10215() - (double)this.depth).method_1019(class_243.method_24954((class_2382)class_2350.field_11035.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new class_243(0.0, 0.0, inBlockBitVector.method_10215() - 0.5).method_1019(class_243.method_24954((class_2382)class_2350.field_11035.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new class_243(15.5, 15.5, inBlockBitVector.method_10215() - 0.5).method_1019(class_243.method_24954((class_2382)class_2350.field_11035.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
    }

    private void includeSouthAxis(IChiselingContext context, class_243 hitBlockPosVector, class_243 inBlockBitVector) {
        class_2338 position = new class_2338(hitBlockPosVector);
        context.include(position, this.clampVectorToBlock(new class_243(0.0, 0.0, inBlockBitVector.method_10215() + (double)this.depth).method_1019(class_243.method_24954((class_2382)class_2350.field_11043.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new class_243(15.5, 15.5, inBlockBitVector.method_10215() + (double)this.depth).method_1019(class_243.method_24954((class_2382)class_2350.field_11043.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new class_243(0.0, 0.0, inBlockBitVector.method_10215() + 0.5).method_1019(class_243.method_24954((class_2382)class_2350.field_11043.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new class_243(15.5, 15.5, inBlockBitVector.method_10215() + 0.5).method_1019(class_243.method_24954((class_2382)class_2350.field_11043.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
    }

    private void includeWestAxis(IChiselingContext context, class_243 hitBlockPosVector, class_243 inBlockBitVector) {
        class_2338 position = new class_2338(hitBlockPosVector);
        context.include(position, this.clampVectorToBlock(new class_243(inBlockBitVector.method_10216() - (double)this.depth, 0.0, 0.0).method_1019(class_243.method_24954((class_2382)class_2350.field_11034.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new class_243(inBlockBitVector.method_10216() - (double)this.depth, 15.5, 15.5).method_1019(class_243.method_24954((class_2382)class_2350.field_11034.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new class_243(inBlockBitVector.method_10216() - 0.5, 0.0, 0.0).method_1019(class_243.method_24954((class_2382)class_2350.field_11034.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new class_243(inBlockBitVector.method_10216() - 0.5, 15.5, 15.5).method_1019(class_243.method_24954((class_2382)class_2350.field_11034.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
    }

    private void includeEastAxis(IChiselingContext context, class_243 hitBlockPosVector, class_243 inBlockBitVector) {
        class_2338 position = new class_2338(hitBlockPosVector);
        context.include(position, this.clampVectorToBlock(new class_243(inBlockBitVector.method_10216() + (double)this.depth, 0.0, 0.0).method_1019(class_243.method_24954((class_2382)class_2350.field_11039.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new class_243(inBlockBitVector.method_10216() + (double)this.depth, 15.5, 15.5).method_1019(class_243.method_24954((class_2382)class_2350.field_11039.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new class_243(inBlockBitVector.method_10216() + 0.5, 0.0, 0.0).method_1019(class_243.method_24954((class_2382)class_2350.field_11039.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new class_243(inBlockBitVector.method_10216() + 0.5, 15.5, 15.5).method_1019(class_243.method_24954((class_2382)class_2350.field_11039.method_10163())).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
    }

    private class_243 clampVectorToBlock(class_243 v) {
        return new class_243(v.method_10216() < 0.0 ? 0.0 : (v.method_10216() >= 1.0 ? (double)0.999f : v.method_10216()), v.method_10214() < 0.0 ? 0.0 : (v.method_10214() >= 1.0 ? (double)0.999f : v.method_10214()), v.method_10215() < 0.0 ? 0.0 : (v.method_10215() >= 1.0 ? (double)0.999f : v.method_10215()));
    }

    @Override
    public class_265 getShape(IChiselingContext context) {
        if (context.getMutator().isEmpty()) {
            return class_259.method_1073();
        }
        return VoxelShapeManager.getInstance().get((IAreaAccessor)context.getMutator().get(), CollisionType.ALL);
    }

    @Override
    @NotNull
    public class_2960 getIcon() {
        return this.iconName;
    }

    @Override
    public class_2561 getDisplayName() {
        return this.displayName;
    }

    @Override
    public class_2561 getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(ModChiselModeGroups.PLANE);
    }
}

